/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.ui.components.gif;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.framework.base.CustomComponent;
import Krasnodar.rockstarnew.framework.base.UIContext;
import Krasnodar.rockstarnew.ui.components.gif.GifDecoder;
import Krasnodar.rockstarnew.utility.colors.Colors;
import Krasnodar.rockstarnew.utility.interfaces.IMinecraft;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import lombok.Generated;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_3298;

public class Gif
extends CustomComponent
implements IMinecraft {
    private final int frameCount;
    private int currentFrame = 0;
    private long lastFrameTime = 0L;
    private final GifDecoder gifDecoder = new GifDecoder();
    private final HashMap<Integer, Integer> frameDurations = new HashMap();
    private class_1043 dynamicTexture;
    private final class_2960 dynamicTextureId;
    private float alpha = 1.0f;
    private final class_1011 sharedImage;

    public Gif(class_2960 gifIdentifier, float x, float y, float width, float height) {
        super(x, y, width, height);
        try {
            class_3298 gifResource = mc.method_1478().getResourceOrThrow(gifIdentifier);
            this.gifDecoder.read(gifResource.method_14482());
        }
        catch (Exception var12) {
            throw new RuntimeException("Failed to load GIF: " + var12.getMessage(), var12);
        }
        this.frameCount = this.gifDecoder.getFrameCount();
        for (int i = 0; i < this.frameCount; ++i) {
            this.frameDurations.put(i, this.gifDecoder.getDelay(i));
        }
        BufferedImage firstFrame = this.gifDecoder.getFrame(0);
        int imgWidth = firstFrame.getWidth();
        int imgHeight = firstFrame.getHeight();
        this.sharedImage = new class_1011(class_1011.class_1012.field_4997, imgWidth, imgHeight, false);
        for (int y1 = 0; y1 < imgHeight; ++y1) {
            for (int x1 = 0; x1 < imgWidth; ++x1) {
                int argb = firstFrame.getRGB(x1, y1);
                this.sharedImage.method_61941(x1, y1, argb);
            }
        }
        this.dynamicTexture = new class_1043(this.sharedImage);
        this.dynamicTextureId = Rockstar.id("gif_texture_" + gifIdentifier.method_12832().hashCode());
        mc.method_1531().method_4616(this.dynamicTextureId, (class_1044)this.dynamicTexture);
        this.dynamicTexture.method_4524();
    }

    private void updateFrame(int frameIndex) {
        BufferedImage frame = this.gifDecoder.getFrame(frameIndex);
        for (int y = 0; y < frame.getHeight(); ++y) {
            for (int x = 0; x < frame.getWidth(); ++x) {
                int argb = frame.getRGB(x, y);
                this.sharedImage.method_61941(x, y, argb);
            }
        }
        this.dynamicTexture.method_4524();
    }

    @Override
    public void update(UIContext context) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastFrameTime > (long)this.frameDurations.get(this.currentFrame).intValue()) {
            this.lastFrameTime = currentTime;
            this.currentFrame = (this.currentFrame + 1) % this.frameCount;
            this.updateFrame(this.currentFrame);
        }
    }

    @Override
    protected void renderComponent(UIContext context) {
        context.drawTexture(this.dynamicTextureId, this.x, this.y, this.width, this.height, Colors.WHITE.mulAlpha(this.alpha));
    }

    public void dispose() {
        if (this.dynamicTexture != null) {
            mc.method_1531().method_4615(this.dynamicTextureId);
            this.dynamicTexture.close();
            this.dynamicTexture = null;
        }
    }

    @Generated
    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }
}

